function [stdresid,UnifMargins, Qt, Rt]=SimulateDccResiduals_t(k,t,DOF,dccparameters)
% PURPOSE:
%     Simulate correlated residuals that follow a dynamic correlation
%     specification same as the DCC(1,1). The residulas follow the
%     Student's T distribution with DOF degrees of freedom
% 
% INPUTS:
%     k                - the number of series to be returned
%     t                - The length of the data to be returned
%     DOF              - the degree of freedom parameter
%     dccparameters    - The DCC parameters (DccP+DccQ x 1)

% OUTPUTS:
%  stdresid    - The simulated residuals from the entered parameters, t x k
%  UnifMargins - The residuals transformed to U(0,1)
%  Qt          - The estimated variance-covariance k x k x t
%  Rt          - The estimated correlation k x k x t
% -------------------------------------------------------------------------
% This function is based on Kevin Sheppard's code in UCSD-GARCH toolbox 
% -------------------------------------------------------------------------
tic; 

CorrMat=gallery('randcorr',k);
m=1;
stdresid=randn(t,k);
U=mvtrnd(eye(k),DOF,t);
rawdata=zeros(t,k);
for i=1:k
    rawdata(:,i)=U(:,i);
end
rawdata=[randn(m,k);rawdata];
Qbar=CorrMat;
[samplstd samplecorr]=cov2corr(Qbar);

   
dccA=dccparameters(1);
dccB=dccparameters(2);
Qt=zeros(k,k,t);
Qt(:,:,1:m)=repmat(Qbar,[1 1 m]);
Rt=zeros(k,k,t);
Rt(:,:,1)=samplecorr;
Qt(:,:,1:m)=repmat(Qbar,[1 1 m]);
P=1;
Q=1;

for j=(m+1):t
    Qt(:,:,j)=Qbar*(1-dccA-dccB);   
    for i=1:P
        Qt(:,:,j)=Qt(:,:,j)+dccA(i)*(stdresid(j-i,:)'*stdresid(j-i,:));
    end
    for i=1:Q
        Qt(:,:,j)=Qt(:,:,j)+dccB(i)*Qt(:,:,j-i);
    end
    Rt(:,:,j)=Qt(:,:,j)./(sqrt(diag(Qt(:,:,j)))*sqrt(diag(Qt(:,:,j)))');
    stdresid(j,:)=rawdata(j,:)*(Rt(:,:,j))^(0.5);

end;
UnifMargins=tcdf(stdresid,DOF);
toc